;Macroeditor for ISN

Func _ISN_Macros_Overview_GenerateListViewColumns()
	Local $Columns = ""

	$Columns = $Columns & StringReplace(_Get_langstr(527), ":", "") & "|"
	$Columns = $Columns & StringReplace(_Get_langstr(17), ":", "") & "|"
	$Columns = $Columns & _Get_langstr(1460) & "|"
	$Columns = $Columns & "id" & "|"
	$Columns = $Columns & "type"

	Return $Columns
EndFunc   ;==>_ISN_Macros_Overview_GenerateListViewColumns

Func _ISN_Macros_EditMacro_GenerateTriggerListViewColumns()
	Local $Columns = ""

	$Columns = $Columns & StringReplace(_Get_langstr(186), ":", "") & "|"
	$Columns = $Columns & "id"

	Return $Columns
EndFunc   ;==>_ISN_Macros_EditMacro_GenerateTriggerListViewColumns

Func _ISN_Macros_EditMacro_GenerateActionsListViewColumns()
	Local $Columns = ""

	$Columns = $Columns & StringReplace(_Get_langstr(1165), ":", "") & "|"
	$Columns = $Columns & _Get_langstr(139) & "|"
	$Columns = $Columns & "id"

	Return $Columns
EndFunc   ;==>_ISN_Macros_EditMacro_GenerateActionsListViewColumns

Func _ISN_Macros_ShowNewMacroGUI()
	;Clear inputs
	GUICtrlSetData($ISN_Macros_NewMacroGUI_MacroNameInput, "")
	GUICtrlSetData($ISN_Macros_NewMacroGUI_MacroCommentInput, "")
	GUICtrlSetData($ISN_Macros_NewMacroGUI_MacroTypeCombo, "")
	GUICtrlSetData($ISN_Macros_NewMacroGUI_MacroTypeCombo, _Get_langstr(1503) & "|" & _Get_langstr(1502), _Get_langstr(1503))
	_ISN_Macros_NewMacroComboEvent()

	;Show GUIs
	GUISetState(@SW_SHOW, $ISN_Macros_NewMacroGUI)
	GUISetState(@SW_DISABLE, $ruleseditor)
EndFunc   ;==>_ISN_Macros_ShowNewMacroGUI

Func _ISN_Macros_NewMacroGUI_Cancel()
	GUISetState(@SW_ENABLE, $ruleseditor)
	GUISetState(@SW_HIDE, $ISN_Macros_NewMacroGUI)
	$Macro_FuncToCallAfterNewMacroIsCreated = ""
EndFunc   ;==>_ISN_Macros_NewMacroGUI_Cancel

Func _ISN_Macros_NewMacroComboEvent()
	Switch GUICtrlRead($ISN_Macros_NewMacroGUI_MacroTypeCombo)

		Case _Get_langstr(1502)
			GUICtrlSetData($ISN_Macros_NewMacroGUI_MacroTypeInfoLabel, _Get_langstr(1506))

		Case _Get_langstr(1503)
			GUICtrlSetData($ISN_Macros_NewMacroGUI_MacroTypeInfoLabel, _Get_langstr(1505))

	EndSwitch
EndFunc   ;==>_ISN_Macros_NewMacroComboEvent

Func _ISN_Macros_NewMacroGUI_OK()
	If GUICtrlRead($ISN_Macros_NewMacroGUI_MacroNameInput) = "" Then
		_Input_Error_FX($ISN_Macros_NewMacroGUI_MacroNameInput)
		Return
	EndIf

	;Hide New Macro GUI
	GUISetState(@SW_ENABLE, $ruleseditor)
	GUISetState(@SW_HIDE, $ISN_Macros_NewMacroGUI)

	;Create new Macro
	Local $NewMacroID = "#isnrule#" & @YEAR & @MON & @MDAY & @MIN & @SEC & Random(0, 200, 1)
	Local $NewMacroName = GUICtrlRead($ISN_Macros_NewMacroGUI_MacroNameInput)
	Local $NewMacroComment = GUICtrlRead($ISN_Macros_NewMacroGUI_MacroCommentInput)
	Local $MacroINI = $Pfad_zur_Project_ISN
	Local $macro_type = "project"

	If GUICtrlRead($ISN_Macros_NewMacroGUI_MacroTypeCombo) = _Get_langstr(1502) Then
		$MacroINI = $GlobalMacrosINIPath
		$macro_type = "global"
	EndIf

	IniWrite($MacroINI, $NewMacroID, "status", "active")
	IniWrite($MacroINI, $NewMacroID, "name", $NewMacroName)
	IniWrite($MacroINI, $NewMacroID, "triggers", "")
	If $NewMacroComment <> "" Then IniWrite($MacroINI, $NewMacroID, "comment", $NewMacroComment)

	;Earn a trophy
	_Earn_trophy(13, 1)

	;Open New Macro
	_Show_new_rule_form($NewMacroID, $macro_type)

	if $Macro_FuncToCallAfterNewMacroIsCreated <> "" then
		Call($Macro_FuncToCallAfterNewMacroIsCreated)
		$Macro_FuncToCallAfterNewMacroIsCreated = ""
	EndIf
EndFunc   ;==>_ISN_Macros_NewMacroGUI_OK

Func _Build_Rulelist()

	;First check files
	;ini for local macros
	If Not FileExists($Pfad_zur_Project_ISN) Then
		If _Check_ISN_Error_Behavior("File " & $Pfad_zur_Project_ISN & " not found!") = 0 Then MsgBox(4096, "Error", "File " & $Pfad_zur_Project_ISN & " not found!")
		Return
	EndIf

	;ini for global macros
	If Not FileExists($GlobalMacrosINIPath) Then
		If _Check_ISN_Error_Behavior("File " & $GlobalMacrosINIPath & " not found!") = 0 Then MsgBox(4096, "Error", "File " & $GlobalMacrosINIPath & " not found!")
		Return
	EndIf



	;Stuff
	Local $count = 0
	Local $MacroName = ""
	Local $MacroComment = ""
	Local $MacroStatus = ""
	Local $NewItem = 0
	Local $MacrosStoreArray[1][5] ;We store all infos for the listview in an array (for pre-sorting)
	_ArrayDelete($MacrosStoreArray, 0)


	;Load global macros
	Local $var = IniReadSectionNames($GlobalMacrosINIPath)
	If Not @error Then
		For $i = 1 To $var[0]
			If StringInStr($var[$i], "#isnrule#") Then ;Every macro section must contain "#isnrule#" in it´s name
				$count = $count + 1
				$MacroName = IniRead($GlobalMacrosINIPath, $var[$i], "name", "")
				$MacroComment = IniRead($GlobalMacrosINIPath, $var[$i], "comment", "")
				$MacroStatus = IniRead($GlobalMacrosINIPath, $var[$i], "status", "active")
				_ArrayAdd($MacrosStoreArray, $MacroName & "|" & $MacroComment & "|" & $MacroStatus & "|" & $var[$i] & "|" & "global")
			EndIf
		Next
	EndIf


	;Load project macros
	Local $var = IniReadSectionNames($Pfad_zur_Project_ISN)
	If Not @error Then
		For $i = 1 To $var[0]
			If StringInStr($var[$i], "#isnrule#") Then ;Every macro section must contain "#isnrule#" in it´s name
				$count = $count + 1
				$MacroName = IniRead($Pfad_zur_Project_ISN, $var[$i], "name", "")
				$MacroComment = IniRead($Pfad_zur_Project_ISN, $var[$i], "comment", "")
				$MacroStatus = IniRead($Pfad_zur_Project_ISN, $var[$i], "status", "active")
				_ArrayAdd($MacrosStoreArray, $MacroName & "|" & $MacroComment & "|" & $MacroStatus & "|" & $var[$i] & "|" & "project")
			EndIf
		Next
	EndIf


	;Sort the array (global arrays on top, and then abc..)
	Local $SortColumns[2]
	$SortColumns[0] = 4
	$SortColumns[1] = 0
	_ArraySort_MultiColumn($MacrosStoreArray, $SortColumns)


	;Clear ListView and lock update
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($listview_projectrules))
	_GUICtrlListView_BeginUpdate($listview_projectrules)

	;Insters items in Listview
	If IsArray($MacrosStoreArray) Then
		For $arraycnt = 0 To UBound($MacrosStoreArray) - 1
			If $MacrosStoreArray[$arraycnt][4] = "project" Then
				$NewItem = _GUICtrlListView_AddItem($listview_projectrules, $MacrosStoreArray[$arraycnt][0], 52) ;project name and icon
			Else
				$NewItem = _GUICtrlListView_AddItem($listview_projectrules, $MacrosStoreArray[$arraycnt][0], 136) ;project name and icon
			EndIf
			_GUICtrlListView_AddSubItem($listview_projectrules, $NewItem, $MacrosStoreArray[$arraycnt][1], 1) ;macro comment
			If $MacrosStoreArray[$arraycnt][2] = "active" Then
				_GUICtrlListView_AddSubItem($listview_projectrules, $NewItem, _Get_langstr(136), 2) ;macro is active
			Else
				_GUICtrlListView_AddSubItem($listview_projectrules, $NewItem, _Get_langstr(137), 2) ;macro is inactive
			EndIf
			_GUICtrlListView_AddSubItem($listview_projectrules, $NewItem, $MacrosStoreArray[$arraycnt][3], 3) ;macro id (rule id)
			_GUICtrlListView_AddSubItem($listview_projectrules, $NewItem, $MacrosStoreArray[$arraycnt][4], 4) ;macro type
		Next
	EndIf


	;Unlock listview
	_GUICtrlListView_SetSelectionMark($listview_projectrules, -1)
	_GUICtrlListView_SetItemSelected($listview_projectrules, -1, False, False)
	_GUICtrlListView_EndUpdate($listview_projectrules)

	GUICtrlSetData($Macros_Statusbar, StringReplace(_Get_langstr(1513), "%1", $count))


	;Copy items to "select macro" GUI (used in the projecttree context menu)
	_GUICtrlListView_CopyAllItems(GUICtrlGetHandle($listview_projectrules), GUICtrlGetHandle($makro_auswaehlen_listview))
EndFunc   ;==>_Build_Rulelist


Func _ISN_MacroTransfer($SourceINI = "", $DestinationINI = "", $IDtoMove = "", $DeleteInSorce = 0 )

	Local $INIFromSectionAddons = "ISNAUTOITSTUDIO"
	Local $INIToSectionAddons = "ISNAUTOITSTUDIO"


	If $DestinationINI = $GlobalMacrosINIPath Then
		$INIToSectionAddons = "config"
	EndIf

	If $SourceINI = $GlobalMacrosINIPath Then
		$INIFromSectionAddons = "config"
	EndIf

	;Write Macro in new INI
	$ReadenMacro = IniReadSection($SourceINI, $IDtoMove)
	If @error Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331) & @CRLF & "(Code 1)", 0, $ruleseditor)
		Return
	EndIf


	$WriteResult = IniWriteSection($DestinationINI, $IDtoMove, $ReadenMacro)
	If @error Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331) & @CRLF & "(Code 2)", 0, $ruleseditor)
		Return
	EndIf

	;Delete Macro in old INI
	If $DeleteInSorce = 1 Then
		If IniDelete($SourceINI, $IDtoMove) = 0 Then
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331) & @CRLF & "(Code 3)", 0, $ruleseditor)
			Return
		EndIf
	EndIf


	;Register the trigger in the new INI and delete from the old one
	$Triggers = IniReadSectionNames($SourceINI)
	If @error Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331) & @CRLF & "(Code 4)", 0, $ruleseditor)
		Return
	Else
		For $i = 0 To UBound($Triggers) - 1
			If StringInStr($Triggers[$i], "#ruletrigger") Then
				$RulesInSection = IniReadSection($SourceINI, $Triggers[$i])
				If @error Or Not IsArray($RulesInSection) Then ContinueLoop
				For $RulesInSectionCnt = 0 To UBound($RulesInSection) - 1
					If $RulesInSection[$RulesInSectionCnt][0] = $IDtoMove Then
						IniWrite($DestinationINI, $Triggers[$i], $IDtoMove, "")

						;Also write additional infos about macroslots (icons, show in treeview..)
						Switch $Triggers[$i]

							Case $Section_Trigger_MacroSlot1
								_MacroTransferAddons(1, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot2
								_MacroTransferAddons(2, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot3
								_MacroTransferAddons(3, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot4
								_MacroTransferAddons(4, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot5
								_MacroTransferAddons(5, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot6
								_MacroTransferAddons(6, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot7
								_MacroTransferAddons(7, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot8
								_MacroTransferAddons(8, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot9
								_MacroTransferAddons(9, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)

							Case $Section_Trigger_MacroSlot10
								_MacroTransferAddons(10, $SourceINI, $DestinationINI, $INIFromSectionAddons, $INIToSectionAddons, $DeleteInSorce)


						EndSwitch
						If $DeleteInSorce = 1 Then IniDelete($SourceINI, $Triggers[$i], $IDtoMove)
					EndIf
				Next
			EndIf
		Next
	EndIf
EndFunc   ;==>_ISN_MacroTransfer

Func _MacroTransferAddons($Nr = 1, $SourceINI = "", $DestinationINI = "", $INIFromSectionAddons = "", $INIToSectionAddons = "", $DeleteInSorce = 0)
	Local $IniRead
	$IniRead = IniRead($SourceINI, $INIFromSectionAddons, "icon_ruleslot" & $Nr, "")
	If $IniRead <> "" Then
		IniWrite($DestinationINI, $INIToSectionAddons, "icon_ruleslot" & $Nr, $IniRead)
		If $DeleteInSorce = 1 Then IniDelete($SourceINI, $INIFromSectionAddons, "icon_ruleslot" & $Nr)
	EndIf
	$IniRead = IniRead($SourceINI, $INIFromSectionAddons, "ruleslot" & $Nr & "_projecttreecontext", "")
	If $IniRead <> "" Then
		IniWrite($DestinationINI, $INIToSectionAddons, "ruleslot" & $Nr & "_projecttreecontext", $IniRead)
		If $DeleteInSorce = 1 Then IniDelete($SourceINI, $INIFromSectionAddons, "ruleslot" & $Nr & "_projecttreecontext")
	EndIf
EndFunc   ;==>_MacroTransferAddons


Func _ISN_MoveMacro()
	If _GUICtrlListView_GetSelectionMark($listview_projectrules) = -1 Then Return
	If _GUICtrlListView_GetItemCount($listview_projectrules) = 0 Then Return
	Local $MsgBoxText = _Get_langstr(1508)
	Local $IDtoMove = _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 3)
	Local $MacroType = _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 4)
	Local $MacroINI = $Pfad_zur_Project_ISN
	If $MacroType = "global" Then
		$MacroINI = $GlobalMacrosINIPath
		$MsgBoxText = _Get_langstr(1509)
	EndIf

	$answer = MsgBox(262144 + 32 + 4, _Get_langstr(48), $MsgBoxText, 0, $ruleseditor)
	If $answer = 6 Then
		Local $SourceINI = ""
		Local $DestinationINI = ""
		If $MacroType = "project" Then
			$SourceINI = $Pfad_zur_Project_ISN
			$DestinationINI = $GlobalMacrosINIPath
		Else
			$SourceINI = $GlobalMacrosINIPath
			$DestinationINI = $Pfad_zur_Project_ISN
		EndIf

		;Check if macro already exists
		Local $var = IniReadSection($DestinationINI, $IDtoMove)
		If Not @error Then
			$overwriteWarning = MsgBox(262144 + 48 + 4, _Get_langstr(394), _Get_langstr(1510), 0, $ruleseditor)
			If @error Or $overwriteWarning <> 6 Then Return
		EndIf

		_ISN_MacroTransfer($SourceINI, $DestinationINI, $IDtoMove, 1)
		_Build_Rulelist()
	EndIf



EndFunc   ;==>_ISN_MoveMacro



Func _Loesche_Regel()
	If _GUICtrlListView_GetSelectionMark($listview_projectrules) = -1 Then Return
	If _GUICtrlListView_GetItemCount($listview_projectrules) = 0 Then Return
	Local $MacroINI = $Pfad_zur_Project_ISN
	$answer = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(539), 0, $ruleseditor)
	If $answer = 6 Then

		$to_delete = _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 3)
		$type_delete = _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 4)
		If $type_delete = "global" Then $MacroINI = $GlobalMacrosINIPath

		IniDelete($MacroINI, $to_delete)

		;Delete every possible trigger
		IniDelete($MacroINI, $Section_Trigger_AfterProjectOpened, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_AfterProjectCompile, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_AfterSave, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_AfterTidy, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_AfterAU3Check, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_BeforeCloseProject, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_AfterFileOpened, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_AfterTabClosed, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_BeforeTesting, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_StopScript, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_ScriptError, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot1, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot2, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot3, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot4, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot5, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot6, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot7, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot8, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot9, $to_delete)
		IniDelete($MacroINI, $Section_Trigger_MacroSlot10, $to_delete)

		_Build_Rulelist()
	EndIf
EndFunc   ;==>_Loesche_Regel

Func _Show_Ruleeditor()
	_Build_Rulelist()
	GUISetState(@SW_SHOW, $ruleseditor)
	GUISetState(@SW_DISABLE, $StudioFenster)

EndFunc   ;==>_Show_Ruleeditor

Func _Hide_Ruleeditor()
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $ruleseditor)
	_Check_Buttons(0)
	_rezize(1,0)
	_Reload_Ruleslots()
EndFunc   ;==>_Hide_Ruleeditor




Func _Show_new_rule_form($MacroID = 0, $MacroType = "project")
;~ if not IsDeclared("nr") then $nr = 0
	If $MacroType = "" Then $MacroType = "project"
	GUICtrlSetData($macro_type_input, $MacroType)
	Local $MacroINI = _ISN_Macros_GetMacroINIPath()


	If $MacroType = "project" Then
		_SetIconAlpha($EditMacro_Icon, $bigiconsdll, 382 + 1, 32, 32)
	Else
		_SetIconAlpha($EditMacro_Icon, $bigiconsdll, 734 + 1, 32, 32)
	EndIf



	If $MacroID == 0 Then
		GUICtrlSetData($new_rule_title, _Get_langstr(520))
		WinSetTitle($newrule_GUI, "", _Get_langstr(520))
		$MacroID = "#isnrule#" & @YEAR & @MON & @MDAY & @MIN & @SEC & Random(0, 200, 1)
		GUICtrlSetData($rule_ID, $MacroID)
	Else
		GUICtrlSetData($new_rule_title, _Get_langstr(523))
		WinSetTitle($newrule_GUI, "", _Get_langstr(523))
		GUICtrlSetData($rule_ID, $MacroID)
	EndIf

	GUICtrlSetData($rule_name_input, IniRead($MacroINI, $MacroID, "name", ""))
	GUICtrlSetData($newrule_GUI_CommentInput, IniRead($MacroINI, $MacroID, "comment", ""))
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($new_rule_triggerlist))
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($new_rule_actionlist))

	;Status
	If IniRead($MacroINI, $MacroID, "status", "active") = "active" Then
		GUICtrlSetState($newrule_GUI_StatusActiveRadio, $GUI_CHECKED)
	Else
		GUICtrlSetState($newrule_GUI_StatusInactiveRadio, $GUI_CHECKED)
	EndIf

	;load triggerlist if possible
	$Triggers = IniRead($MacroINI, $MacroID, "triggers", "")
	$triggers_array = StringSplit($Triggers, "|", 2)
	For $u = 0 To UBound($triggers_array) - 1
		If $triggers_array[$u] <> "" Then
			_GUICtrlListView_AddItem($new_rule_triggerlist, _get_triggername_by_section($triggers_array[$u]), 53)
			_GUICtrlListView_AddSubItem($new_rule_triggerlist, _GUICtrlListView_GetItemCount($new_rule_triggerlist) - 1, $triggers_array[$u], 1)
		EndIf
	Next

	_Reload_Actionlist()
	GUISetState(@SW_SHOW, $newrule_GUI)
	GUISetState(@SW_HIDE, $ruleseditor)

EndFunc   ;==>_Show_new_rule_form

;~ Func _Neues_Makro_Abbrechen()
;~ 	IniReadSection($Pfad_zur_Project_ISN, GUICtrlRead($rule_ID))
;~ 	If @error = 1 Then
;~ 		$to_delete = GUICtrlRead($rule_ID)
;~ 		IniDelete($Pfad_zur_Project_ISN, $to_delete)
;~ 		;Delete every possible trigger
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_AfterProjectOpened, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_AfterProjectCompile, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_AfterSave, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_AfterTidy, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_AfterAU3Check, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_BeforeCloseProject, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_AfterFileOpened, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_AfterTabClosed, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_BeforeTesting, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_StopScript, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_ScriptError, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_MacroSlot1, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_MacroSlot2, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_MacroSlot3, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_MacroSlot4, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_MacroSlot5, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_MacroSlot6, $to_delete)
;~ 		IniDelete($Pfad_zur_Project_ISN, $Section_Trigger_MacroSlot7, $to_delete)
;~ 		_Show_Ruleeditor()
;~ 		GUISetState(@SW_HIDE, $newrule_GUI)
;~ 	Else
;~ 		_Speichere_Neue_Regel()
;~ 	EndIf
;~ EndFunc   ;==>_Neues_Makro_Abbrechen




Func _Add_Trigger_to_list()


	;Nur eine Regel Pro Regelslot
;~ 	$x = $Trigger_Selection_combo_ARRAY[_GUICtrlComboBox_GetCurSel($Trigger_Combolist)]
;~ 	If $x = $Section_Trigger_MacroSlot1 Or $x = $Section_Trigger_MacroSlot2 Or $x = $Section_Trigger_MacroSlot3 Or $x = $Section_Trigger_MacroSlot4 Or $x = $Section_Trigger_MacroSlot5 Or $x = $Section_Trigger_MacroSlot6 Or $x = $Section_Trigger_MacroSlot7 Or $x = $Section_Trigger_MacroSlot8 Or $x = $Section_Trigger_MacroSlot9 Or $x = $Section_Trigger_MacroSlot10   Then
;~ 		$sections = IniReadSection($Pfad_zur_Project_ISN, $x)
;~ 		If Not @error Then
;~ 			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(616), 0, $choose_trigger)
;~ 			Return
;~ 		EndIf
;~ 	EndIf

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	;falls schon in der liste -> irgnore
	$iI = _GUICtrlListView_FindText($new_rule_triggerlist, GUICtrlRead($Trigger_Combolist))
	If $iI = -1 Then
		_GUICtrlListView_AddItem($new_rule_triggerlist, GUICtrlRead($Trigger_Combolist), 53)
		_GUICtrlListView_AddSubItem($new_rule_triggerlist, _GUICtrlListView_GetItemCount($new_rule_triggerlist) - 1, $Trigger_Selection_combo_ARRAY[_GUICtrlComboBox_GetCurSel($Trigger_Combolist)], 1)
		IniWrite($MacroINI, $Trigger_Selection_combo_ARRAY[_GUICtrlComboBox_GetCurSel($Trigger_Combolist)], GUICtrlRead($rule_ID), "")
	EndIf
	_close_Add_Trigger()
	If $iI = -1 Then
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 01" Then _Show_Set_Ruleslot_icon(1)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 02" Then _Show_Set_Ruleslot_icon(2)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 03" Then _Show_Set_Ruleslot_icon(3)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 04" Then _Show_Set_Ruleslot_icon(4)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 05" Then _Show_Set_Ruleslot_icon(5)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 06" Then _Show_Set_Ruleslot_icon(6)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 07" Then _Show_Set_Ruleslot_icon(7)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 08" Then _Show_Set_Ruleslot_icon(8)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 09" Then _Show_Set_Ruleslot_icon(9)
		If GUICtrlRead($Trigger_Combolist) = _Get_langstr(1501) & " 10" Then _Show_Set_Ruleslot_icon(10)
	EndIf

EndFunc   ;==>_Add_Trigger_to_list

Func _close_Add_Trigger()
	GUISetState(@SW_ENABLE, $newrule_GUI)
	GUISetState(@SW_HIDE, $choose_trigger)
EndFunc   ;==>_close_Add_Trigger

Func _delete_trigger_from_list()
	If _GUICtrlListView_GetSelectionMark($new_rule_triggerlist) = -1 Then Return
	If _GUICtrlListView_GetItemCount($new_rule_triggerlist) = 0 Then Return
	Local $MacroINI = _ISN_Macros_GetMacroINIPath()
	IniDelete($MacroINI, _GUICtrlListView_GetItemText($new_rule_triggerlist, _GUICtrlListView_GetSelectionMark($new_rule_triggerlist), 1), GUICtrlRead($rule_ID))
	_GUICtrlListView_DeleteItem(GUICtrlGetHandle($new_rule_triggerlist), _GUICtrlListView_GetSelectionMark($new_rule_triggerlist))
EndFunc   ;==>_delete_trigger_from_list

Func _Speichere_Neue_Regel()
	If GUICtrlRead($rule_name_input) = "" Then
		_Input_Error_FX($rule_name_input)
		Return
	EndIf

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	If GUICtrlRead($newrule_GUI_StatusActiveRadio) = $GUI_CHECKED Then
		IniWrite($MacroINI, GUICtrlRead($rule_ID), "status", "active")
	Else
		IniWrite($MacroINI, GUICtrlRead($rule_ID), "status", "inactive")
	EndIf

	IniWrite($MacroINI, GUICtrlRead($rule_ID), "name", GUICtrlRead($rule_name_input))
	IniWrite($MacroINI, GUICtrlRead($rule_ID), "comment", GUICtrlRead($newrule_GUI_CommentInput))
	$triggerstring = ""
	For $i = 0 To _GUICtrlListView_GetItemCount($new_rule_triggerlist) - 1
		$triggerstring = $triggerstring & _GUICtrlListView_GetItemText($new_rule_triggerlist, $i, 1) & "|"
	Next
	IniWrite($MacroINI, GUICtrlRead($rule_ID), "triggers", $triggerstring)
	_Show_Ruleeditor()
	GUISetState(@SW_HIDE, $newrule_GUI)
	_ISN_VariablesSelector_HideGUI()
	_Earn_trophy(13, 1)
EndFunc   ;==>_Speichere_Neue_Regel

Func _Editiere_Regel()
	If _GUICtrlListView_GetSelectionMark($listview_projectrules) = -1 Then Return
	If _GUICtrlListView_GetItemCount($listview_projectrules) = 0 Then Return
	Local $RuleID = _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 3)
	Local $RuleType = _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 4)
	_Show_new_rule_form($RuleID, $RuleType)
EndFunc   ;==>_Editiere_Regel

Func _Show_new_rule_event()
	_Show_new_rule_form(0)
EndFunc   ;==>_Show_new_rule_event




Func _Rule_toggle_active()
	If _GUICtrlListView_GetSelectionMark($listview_projectrules) = -1 Then Return
	If _GUICtrlListView_GetItemCount($listview_projectrules) = 0 Then Return

	Local $MacroINI = $Pfad_zur_Project_ISN
	If _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 4) = "global" Then $MacroINI = $GlobalMacrosINIPath

	$old_sec = _GUICtrlListView_GetSelectionMark($listview_projectrules)
	If IniRead($MacroINI, _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 3), "status", "active") = "active" Then
		IniWrite($MacroINI, _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 3), "status", "inactive")
	Else
		IniWrite($MacroINI, _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 3), "status", "active")
	EndIf
	_Build_Rulelist()
	_GUICtrlListView_SetItemSelected($listview_projectrules, $old_sec, True, True)
	_load_ruledetails()
EndFunc   ;==>_Rule_toggle_active

Func _load_ruledetails()
	If _GUICtrlListView_GetSelectionMark($listview_projectrules) = -1 Then
		GUICtrlSetData($btn_toggle_rulestatus, _Get_langstr(514))
		Return
	EndIf
	If _GUICtrlListView_GetItemCount($listview_projectrules) = 0 Then Return
	If _GUICtrlListView_GetItemText($listview_projectrules, _GUICtrlListView_GetSelectionMark($listview_projectrules), 2) = _Get_langstr(136) Then
		GUICtrlSetData($btn_toggle_rulestatus, _Get_langstr(514))
		Button_AddIcon($btn_toggle_rulestatus, $smallIconsdll, 1173, 0)
	Else
		GUICtrlSetData($btn_toggle_rulestatus, _Get_langstr(515))
		Button_AddIcon($btn_toggle_rulestatus, $smallIconsdll, 314, 0)
	EndIf
EndFunc   ;==>_load_ruledetails









Func _close_Add_action()
	GUISetState(@SW_ENABLE, $newrule_GUI)
	GUISetState(@SW_HIDE, $choose_action_GUI)
EndFunc   ;==>_close_Add_action


Func _Add_action_to_list_event()
	_Add_action_to_list("")
EndFunc   ;==>_Add_action_to_list_event

Func _Add_action_to_list($Action_ID = "")
	$new_taskid = @MDAY & @MIN & @SEC & Random(0, 300, 1)
	If $Action_ID = "" Then
		_Config_Ruleaction($Action_Selection_combo_ARRAY[_GUICtrlComboBox_GetCurSel($action_Combolist)], $new_taskid)
	Else
		_Config_Ruleaction($Action_ID, $new_taskid)
	EndIf
EndFunc   ;==>_Add_action_to_list

Func _Reload_Actionlist()
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($new_rule_actionlist))
	_GUICtrlListView_BeginUpdate($new_rule_actionlist)

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	;load actionlist
	$actions_string = IniRead($MacroINI, GUICtrlRead($rule_ID), "actions", "")
	$actions_array = StringSplit($actions_string, "|", 2)
	For $u = 0 To UBound($actions_array) - 1
		If $actions_array[$u] <> "" Then
			_GUICtrlListView_AddItem($new_rule_actionlist, _get_actionname_by_section($actions_array[$u]), 54)
			_GUICtrlListView_AddSubItem($new_rule_actionlist, _GUICtrlListView_GetItemCount($new_rule_actionlist) - 1, _get_details_by_section($actions_array[$u]), 1)
			_GUICtrlListView_AddSubItem($new_rule_actionlist, _GUICtrlListView_GetItemCount($new_rule_actionlist) - 1, $actions_array[$u], 2)
		EndIf
	Next

	_GUICtrlListView_EndUpdate($new_rule_actionlist)

EndFunc   ;==>_Reload_Actionlist


Func _Move_actionitem_up()
	If _GUICtrlListView_GetSelectionMark($new_rule_actionlist) = -1 Then Return
	If _GUICtrlListView_GetItemCount($new_rule_actionlist) = 0 Then Return

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()


	_GUICtrlListView_MoveItems($new_rule_actionlist, -1)
	_GUICtrlListView_EnsureVisible($new_rule_actionlist, _GUICtrlListView_GetSelectionMark($new_rule_actionlist))
	_GUICtrlListView_SetItemSelected($new_rule_actionlist, _GUICtrlListView_GetSelectionMark($new_rule_actionlist), True, True)
	$actionstring = ""
	For $i = 0 To _GUICtrlListView_GetItemCount($new_rule_actionlist) - 1
		$actionstring = $actionstring & _GUICtrlListView_GetItemText($new_rule_actionlist, $i, 2) & "|"
	Next
	IniWrite($MacroINI, GUICtrlRead($rule_ID), "actions", $actionstring)
EndFunc   ;==>_Move_actionitem_up

Func _Move_actionitem_down()
	If _GUICtrlListView_GetSelectionMark($new_rule_actionlist) = -1 Then Return
	If _GUICtrlListView_GetItemCount($new_rule_actionlist) = 0 Then Return

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	_GUICtrlListView_MoveItems($new_rule_actionlist, 1)
	_GUICtrlListView_EnsureVisible($new_rule_actionlist, _GUICtrlListView_GetSelectionMark($new_rule_actionlist))
	_GUICtrlListView_SetItemSelected($new_rule_actionlist, _GUICtrlListView_GetSelectionMark($new_rule_actionlist), True, True)
	$actionstring = ""
	For $i = 0 To _GUICtrlListView_GetItemCount($new_rule_actionlist) - 1
		$actionstring = $actionstring & _GUICtrlListView_GetItemText($new_rule_actionlist, $i, 2) & "|"
	Next
	IniWrite($MacroINI, GUICtrlRead($rule_ID), "actions", $actionstring)
EndFunc   ;==>_Move_actionitem_down

Func _edit_action()
	If _GUICtrlListView_GetSelectionMark($new_rule_actionlist) = -1 Then Return
	If _GUICtrlListView_GetItemCount($new_rule_actionlist) = 0 Then Return
	$section = _GUICtrlListView_GetItemText($new_rule_actionlist, _GUICtrlListView_GetSelectionMark($new_rule_actionlist), 2)
	$action = StringTrimRight($section, StringLen($section) - StringInStr($section, "[") + 1)
	$Action_ID = _StringBetween($section, '[', ']')
	_Config_Ruleaction($action, $Action_ID[0])
EndFunc   ;==>_edit_action

Func _remove_action()
	If _GUICtrlListView_GetSelectionMark($new_rule_actionlist) = -1 Then Return
	If _GUICtrlListView_GetItemCount($new_rule_actionlist) = 0 Then Return

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	$section = _GUICtrlListView_GetItemText($new_rule_actionlist, _GUICtrlListView_GetSelectionMark($new_rule_actionlist), 2)
	$action = StringTrimRight($section, StringLen($section) - StringInStr($section, "[") + 1)
	$Action_ID = _StringBetween($section, '[', ']')
	Switch $action
		Case $Key_Action1
			IniDelete($MacroINI, GUICtrlRead($rule_ID), "statusbar_string[" & $Action_ID[0] & "]")
		Case $Key_Action2
			IniDelete($MacroINI, GUICtrlRead($rule_ID), "sleep_time[" & $Action_ID[0] & "]")
		Case $Key_Action4
			IniDelete($MacroINI, GUICtrlRead($rule_ID), "fileoperation_mode[" & $Action_ID[0] & "]")
			IniDelete($MacroINI, GUICtrlRead($rule_ID), "fileoperation_source[" & $Action_ID[0] & "]")
			IniDelete($MacroINI, GUICtrlRead($rule_ID), "fileoperation_target[" & $Action_ID[0] & "]")
			IniDelete($MacroINI, GUICtrlRead($rule_ID), "fileoperation_mustconfirm[" & $Action_ID[0] & "]")



	EndSwitch
	_GUICtrlListView_DeleteItem(GUICtrlGetHandle($new_rule_actionlist), _GUICtrlListView_GetSelectionMark($new_rule_actionlist))
	$actionstring = ""
	For $i = 0 To _GUICtrlListView_GetItemCount($new_rule_actionlist) - 1
		$actionstring = $actionstring & _GUICtrlListView_GetItemText($new_rule_actionlist, $i, 2) & "|"
	Next
	IniWrite($MacroINI, GUICtrlRead($rule_ID), "actions", $actionstring)
	_Reload_Actionlist()
EndFunc   ;==>_remove_action

Func _Export_Rules()
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($MacroExportListView))
	_GUICtrlListView_BeginUpdate($MacroExportListView)
	_GUICtrlListView_CopyAllItems(GUICtrlGetHandle($listview_projectrules), GUICtrlGetHandle($MacroExportListView))
	_GUICtrlListView_EndUpdate($MacroExportListView)

	GUISetState(@SW_SHOW, $MacroExportGUI)
	GUISetState(@SW_DISABLE, $ruleseditor)

EndFunc

Func _Export_Rules_Cancel()
	GUISetState(@SW_ENABLE, $ruleseditor)
	GUISetState(@SW_HIDE, $MacroExportGUI)
EndFunc



Func _Export_Rules_OK()
	_Export_Rules_Cancel()
	if _GUICtrlListView_GetItemCount($MacroExportListView) = 0 then return
	Local $IsChecked = 0
	For $cnt = 0 To _GUICtrlListView_GetItemCount($MacroExportListView) - 1
		If _GUICtrlListView_GetItemChecked ($MacroExportListView, $cnt) Then $IsChecked = 1
	Next
	if $IsChecked = 0 then return

	$DestinationFile = FileSaveDialog(_Get_langstr(589), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "ISN AutoIt Studio Macros (*.ini)", 18, "Macro.ini", $ruleseditor)
	FileChangeDir(@ScriptDir)
	If $DestinationFile = "" Then Return
	If @error > 0 Then Return
	if FileExists($DestinationFile) then FileDelete($DestinationFile)


	Local $MacroINIToExport
	Local $MacroType
	Local $ID

	For $cnt = 0 To _GUICtrlListView_GetItemCount($MacroExportListView) - 1
		If _GUICtrlListView_GetItemChecked ($MacroExportListView, $cnt) Then
			$ID = _GUICtrlListView_GetItemText($MacroExportListView, $cnt, 3)
			$MacroType = _GUICtrlListView_GetItemText($MacroExportListView, $cnt, 4)
			if $MacroType = "project" Then
				$MacroINIToExport = $Pfad_zur_Project_ISN
				else
				$MacroINIToExport = $GlobalMacrosINIPath
			EndIf
			_ISN_MacroTransfer($MacroINIToExport, $DestinationFile, $ID, 0)
		EndIf
	Next


	MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(164), 0, $ruleseditor)
EndFunc

Func _import_Rules()
	If $Skin_is_used = "true" Then
		$InputFile = _WinAPI_OpenFileDlg(_Get_langstr(590), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "ISN AutoIt Studio Macro (*.ini)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $ruleseditor)
	Else
		$InputFile = FileOpenDialog(_Get_langstr(590), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "ISN AutoIt Studio Macro (*.ini)", 1 + 2, "", $ruleseditor)
	EndIf

	FileChangeDir(@ScriptDir)
	If @error Then Return
	If $InputFile = "" Then Return

	GUICtrlSetData($MacroImportPathBackup, $InputFile)
	GUICtrlSetData($ISN_Macros_ImportCombo, "")
	GUICtrlSetData($ISN_Macros_ImportCombo, _Get_langstr(1503) & "|" & _Get_langstr(1502), _Get_langstr(1503))

	GUISetState(@SW_SHOW, $MacroImportGUI)
	GUISetState(@SW_DISABLE, $ruleseditor)

EndFunc   ;==>_import_Rules


Func _ImportRules_OK()
	_ImportRules_Cancel()
	Local $InputFile = GUICtrlRead($MacroImportPathBackup)
	If Not FileExists($InputFile) Then Return

	$INISection = IniReadSectionNames($InputFile)
	If @error Then Return

	Local $DestinationINI

	If GUICtrlRead($ISN_Macros_ImportCombo) = _Get_langstr(1503) Then
		$DestinationINI = $Pfad_zur_Project_ISN
	Else
		$DestinationINI = $GlobalMacrosINIPath
	EndIf

	For $i = 0 To UBound($INISection) - 1
		If StringInStr($INISection[$i], "#isnrule#") Then
			Local $var = IniReadSection($DestinationINI, $INISection[$i])
			If Not @error Then
				$overwriteWarning = MsgBox(262144 + 48 + 4, _Get_langstr(394), _Get_langstr(1510), 0, $ruleseditor)
				If @error Or $overwriteWarning <> 6 Then ContinueLoop
			EndIf
			_ISN_MacroTransfer($InputFile, $DestinationINI, $INISection[$i], 0)
		EndIf
	Next

	FileChangeDir(@ScriptDir)
	_Build_Rulelist()
	MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(591), 0, $ruleseditor)

EndFunc   ;==>_ImportRules_OK

Func _ImportRules_Cancel()
	GUISetState(@SW_ENABLE, $ruleseditor)
	GUISetState(@SW_HIDE, $MacroImportGUI)
EndFunc   ;==>_ImportRules_Cancel

;===============================================================================
; Function Name:    _GUICtrlListView_MoveItems()
; Description:      Moves Up or Down selected item(s) in ListView.
;
; Parameter(s):     $hListView          - ControlID or Handle of ListView control.
;                   $iDirection         - Define in what direction item(s) will move:
;                                           -1 - Move Up.
;                                            1 - Move Down.
;
; Requirement(s):   AutoIt 3.3.0.0
;
; Return Value(s):  On seccess - Move selected item(s) Up/Down and return 1.
;                   On failure - Return "" (empty string) and set @error as following:
;                                                                  1 - No selected item(s).
;                                                                  2 - $iDirection is wrong value (not 1 and not -1).
;                                                                  3 - Item(s) can not be moved, reached last/first item.
;
; Note(s):          * If you select like 15-20 (or more) items, moving them can take a while :( (second or two).
;
; Author(s):        G.Sandler a.k.a CreatoR
;===============================================================================
Func _GUICtrlListView_MoveItems($hListView, $iDirection)
	Local $aSelected_Indices = _GUICtrlListView_GetSelectedIndices($hListView, 1)

	If UBound($aSelected_Indices) < 2 Then Return SetError(1, 0, "")
	If $iDirection <> 1 And $iDirection <> -1 Then Return SetError(2, 0, "")

	Local $iTotal_Items = _GUICtrlListView_GetItemCount($hListView)
	Local $iTotal_Columns = _GUICtrlListView_GetColumnCount($hListView)

	Local $iUbound = UBound($aSelected_Indices) - 1, $iNum = 1, $iStep = 1

	Local $iCurrent_Index, $iUpDown_Index, $sCurrent_ItemText, $sUpDown_ItemText
	Local $iCurrent_Index, $iCurrent_CheckedState, $iUpDown_CheckedState
	Local $iImage_Current_Index, $iImage_UpDown_Index

	If ($iDirection = -1 And $aSelected_Indices[1] = 0) Or _
			($iDirection = 1 And $aSelected_Indices[$iUbound] = $iTotal_Items - 1) Then Return SetError(3, 0, "")

	ControlListView($hListView, "", "", "SelectClear")

	If $iDirection = 1 Then
		$iNum = $iUbound
		$iUbound = 1
		$iStep = -1
	EndIf

	For $i = $iNum To $iUbound Step $iStep
		$iCurrent_Index = $aSelected_Indices[$i]
		$iUpDown_Index = $aSelected_Indices[$i] + 1
		If $iDirection = -1 Then $iUpDown_Index = $aSelected_Indices[$i] - 1

		$iCurrent_CheckedState = _GUICtrlListView_GetItemChecked($hListView, $iCurrent_Index)
		$iUpDown_CheckedState = _GUICtrlListView_GetItemChecked($hListView, $iUpDown_Index)

		_GUICtrlListView_SetItemSelected($hListView, $iUpDown_Index)

		For $j = 0 To $iTotal_Columns - 1
			$sCurrent_ItemText = _GUICtrlListView_GetItemText($hListView, $iCurrent_Index, $j)
			$sUpDown_ItemText = _GUICtrlListView_GetItemText($hListView, $iUpDown_Index, $j)

			If _GUICtrlListView_GetImageList($hListView, 1) <> 0 Then
				$iImage_Current_Index = _GUICtrlListView_GetItemImage($hListView, $iCurrent_Index, $j)
				$iImage_UpDown_Index = _GUICtrlListView_GetItemImage($hListView, $iUpDown_Index, $j)

				_GUICtrlListView_SetItemImage($hListView, $iCurrent_Index, $iImage_UpDown_Index, $j)
				_GUICtrlListView_SetItemImage($hListView, $iUpDown_Index, $iImage_Current_Index, $j)
			EndIf

			_GUICtrlListView_SetItemText($hListView, $iUpDown_Index, $sCurrent_ItemText, $j)
			_GUICtrlListView_SetItemText($hListView, $iCurrent_Index, $sUpDown_ItemText, $j)
		Next

		_GUICtrlListView_SetItemChecked($hListView, $iUpDown_Index, $iCurrent_CheckedState)
		_GUICtrlListView_SetItemChecked($hListView, $iCurrent_Index, $iUpDown_CheckedState)

		_GUICtrlListView_SetItemSelected($hListView, $iUpDown_Index, 0)
	Next

	For $i = 1 To UBound($aSelected_Indices) - 1
		$iUpDown_Index = $aSelected_Indices[$i] + 1
		If $iDirection = -1 Then $iUpDown_Index = $aSelected_Indices[$i] - 1
		_GUICtrlListView_SetItemSelected($hListView, $iUpDown_Index)
	Next

	_GUICtrlListView_SetSelectionMark($hListView, $iUpDown_Index)
	Return 1
EndFunc   ;==>_GUICtrlListView_MoveItems

Func _edit_trigger()
	If _GUICtrlListView_GetSelectionMark($new_rule_triggerlist) = -1 Then Return
	If _GUICtrlListView_GetItemCount($new_rule_triggerlist) = 0 Then Return
	$text = _GUICtrlListView_GetItemText($new_rule_triggerlist, _GUICtrlListView_GetSelectionMark($new_rule_triggerlist), 0)
	Switch $text

		Case _Get_langstr(1501) & " 01"
			_Show_Set_Ruleslot_icon(1)
			Return

		Case _Get_langstr(1501) & " 02"
			_Show_Set_Ruleslot_icon(2)
			Return

		Case _Get_langstr(1501) & " 03"
			_Show_Set_Ruleslot_icon(3)
			Return

		Case _Get_langstr(1501) & " 04"
			_Show_Set_Ruleslot_icon(4)
			Return

		Case _Get_langstr(1501) & " 05"
			_Show_Set_Ruleslot_icon(5)
			Return

		Case _Get_langstr(1501) & " 06"
			_Show_Set_Ruleslot_icon(6)
			Return

		Case _Get_langstr(1501) & " 07"
			_Show_Set_Ruleslot_icon(7)
			Return

		Case _Get_langstr(1501) & " 08"
			_Show_Set_Ruleslot_icon(8)
			Return

		Case _Get_langstr(1501) & " 09"
			_Show_Set_Ruleslot_icon(9)
			Return

		Case _Get_langstr(1501) & " 10"
			_Show_Set_Ruleslot_icon(10)
			Return

	EndSwitch
	MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(549), 0, $newrule_GUI)
EndFunc   ;==>_edit_trigger


Func _make_icon_default()
	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	Local $INISection = "ISNAUTOITSTUDIO"
	If $MacroINI = $GlobalMacrosINIPath Then $INISection = "config"

	If $ID_Holder_For_ruleiconconfig = 1 Then IniWrite($MacroINI, $INISection, "icon_ruleslot1", "1")
	If $ID_Holder_For_ruleiconconfig = 2 Then IniWrite($MacroINI, $INISection, "icon_ruleslot2", "909")
	If $ID_Holder_For_ruleiconconfig = 3 Then IniWrite($MacroINI, $INISection, "icon_ruleslot3", "1020")
	If $ID_Holder_For_ruleiconconfig = 4 Then IniWrite($MacroINI, $INISection, "icon_ruleslot4", "1130")
	If $ID_Holder_For_ruleiconconfig = 5 Then IniWrite($MacroINI, $INISection, "icon_ruleslot5", "1241")
	If $ID_Holder_For_ruleiconconfig = 6 Then IniWrite($MacroINI, $INISection, "icon_ruleslot6", "1345")
	If $ID_Holder_For_ruleiconconfig = 7 Then IniWrite($MacroINI, $INISection, "icon_ruleslot7", "1456")
	If $ID_Holder_For_ruleiconconfig = 8 Then IniWrite($MacroINI, $INISection, "icon_ruleslot8", "1567")
	If $ID_Holder_For_ruleiconconfig = 9 Then IniWrite($MacroINI, $INISection, "icon_ruleslot9", "1674")
	If $ID_Holder_For_ruleiconconfig = 10 Then IniWrite($MacroINI, $INISection, "icon_ruleslot10", "1939")
	_Show_Set_Ruleslot_icon($ID_Holder_For_ruleiconconfig)
EndFunc   ;==>_make_icon_default

Func _Show_Set_Ruleslot_icon($slot = 1)
	$ID_Holder_For_ruleiconconfig = $slot
	GUISetState(@SW_DISABLE, $newrule_GUI)

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	Local $INISection = "ISNAUTOITSTUDIO"
	If $MacroINI = $GlobalMacrosINIPath Then $INISection = "config"

	If $ID_Holder_For_ruleiconconfig = 1 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot1", "1")
	If $ID_Holder_For_ruleiconconfig = 2 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot2", "909")
	If $ID_Holder_For_ruleiconconfig = 3 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot3", "1020")
	If $ID_Holder_For_ruleiconconfig = 4 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot4", "1130")
	If $ID_Holder_For_ruleiconconfig = 5 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot5", "1241")
	If $ID_Holder_For_ruleiconconfig = 6 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot6", "1345")
	If $ID_Holder_For_ruleiconconfig = 7 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot7", "1456")
	If $ID_Holder_For_ruleiconconfig = 8 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot8", "1567")
	If $ID_Holder_For_ruleiconconfig = 9 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot9", "1674")
	If $ID_Holder_For_ruleiconconfig = 10 Then $read = IniRead($MacroINI, $INISection, "icon_ruleslot10", "1939")
	GUICtrlSetImage($ruleslot_ico_preview, $smallIconsdll, $read)



	If IniRead($MacroINI, $INISection, "ruleslot" & $ID_Holder_For_ruleiconconfig & "_projecttreecontext", "0") = 0 Then
		GUICtrlSetState($choose_ruleslot_checkboxprojecttree, $GUI_UNCHECKED)
	Else
		GUICtrlSetState($choose_ruleslot_checkboxprojecttree, $GUI_CHECKED)
	EndIf

	GUISetState(@SW_SHOW, $choose_ruleslot_icon)
EndFunc   ;==>_Show_Set_Ruleslot_icon

Func _Hide_Ruleslot_icon()
	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	Local $INISection = "ISNAUTOITSTUDIO"
	If $MacroINI = $GlobalMacrosINIPath Then $INISection = "config"

	If GUICtrlRead($choose_ruleslot_checkboxprojecttree) = $GUI_CHECKED Then
		IniWrite($MacroINI, $INISection, "ruleslot" & $ID_Holder_For_ruleiconconfig & "_projecttreecontext", "1")
	Else
		IniWrite($MacroINI, $INISection, "ruleslot" & $ID_Holder_For_ruleiconconfig & "_projecttreecontext", "0")
	EndIf
	GUISetState(@SW_ENABLE, $newrule_GUI)
	GUISetState(@SW_HIDE, $choose_ruleslot_icon)
EndFunc   ;==>_Hide_Ruleslot_icon

Func _select_icon()

	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	Local $INISection = "ISNAUTOITSTUDIO"
	If $MacroINI = $GlobalMacrosINIPath Then $INISection = "config"

	GUISetState(@SW_DISABLE, $choose_ruleslot_icon)
	$iStartIndex = 1
	If $ID_Holder_For_ruleiconconfig = 1 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot1", "1")
	If $ID_Holder_For_ruleiconconfig = 2 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot2", "909")
	If $ID_Holder_For_ruleiconconfig = 3 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot3", "1020")
	If $ID_Holder_For_ruleiconconfig = 4 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot4", "1130")
	If $ID_Holder_For_ruleiconconfig = 5 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot5", "1241")
	If $ID_Holder_For_ruleiconconfig = 6 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot6", "1345")
	If $ID_Holder_For_ruleiconconfig = 7 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot7", "1456")
	If $ID_Holder_For_ruleiconconfig = 8 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot8", "1567")
	If $ID_Holder_For_ruleiconconfig = 9 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot9", "1674")
	If $ID_Holder_For_ruleiconconfig = 10 Then $iStartIndex = IniRead($MacroINI, $INISection, "icon_ruleslot10", "1939")
	$Selected_Icon = -1
	Icons_GUIUpdate()
	GUISetState(@SW_SHOW, $gui_select_icon)
EndFunc   ;==>_select_icon

Func _select_icons_next()
	$iStartIndex = $iStartIndex + 30
	Icons_GUIUpdate()
EndFunc   ;==>_select_icons_next

Func _select_icons_prev()
	$iStartIndex = $iStartIndex - 30
	If $iStartIndex < 1 Then $iStartIndex = 1
	Icons_GUIUpdate()
EndFunc   ;==>_select_icons_prev

Func Icons_GUIUpdate()
	For $iCntRow = 0 To 4
		For $iCntCol = 0 To 5
			$iCurIndex = $iCntRow * 6 + $iCntCol
			GUICtrlSetImage($ahIcons[$iCurIndex], $sFilename, $iOrdinal * ($iCurIndex + $iStartIndex))
			If $iOrdinal = -1 Then
				GUICtrlSetData($ahLabels[$iCurIndex], -($iCurIndex + $iStartIndex))
			Else
				GUICtrlSetData($ahLabels[$iCurIndex], '"' & ($iCurIndex + $iStartIndex) & '"')
			EndIf
		Next
	Next
	; This is because we don't want negative values
	If $iStartIndex = 1 Then
		GUICtrlSetState($hPrev, $GUI_DISABLE)
	Else
		GUICtrlSetState($hPrev, $GUI_ENABLE)
	EndIf
EndFunc   ;==>Icons_GUIUpdate

Func _Makroslot_Icon_Abbrechen()
	GUISetState(@SW_ENABLE, $choose_ruleslot_icon)
	GUISetState(@SW_HIDE, $gui_select_icon)
EndFunc   ;==>_Makroslot_Icon_Abbrechen



Func _hit_icon()
	Local $MacroINI = _ISN_Macros_GetMacroINIPath()

	Local $INISection = "ISNAUTOITSTUDIO"
	If $MacroINI = $GlobalMacrosINIPath Then $INISection = "config"

	$read = GUICtrlRead(@GUI_CtrlId)
	$read = StringReplace($read, "-", "")
	$read = Number($read)
	GUISetState(@SW_ENABLE, $choose_ruleslot_icon)
	GUISetState(@SW_HIDE, $gui_select_icon)
	If $ID_Holder_For_ruleiconconfig = 1 Then IniWrite($MacroINI, $INISection, "icon_ruleslot1", $read)
	If $ID_Holder_For_ruleiconconfig = 2 Then IniWrite($MacroINI, $INISection, "icon_ruleslot2", $read)
	If $ID_Holder_For_ruleiconconfig = 3 Then IniWrite($MacroINI, $INISection, "icon_ruleslot3", $read)
	If $ID_Holder_For_ruleiconconfig = 4 Then IniWrite($MacroINI, $INISection, "icon_ruleslot4", $read)
	If $ID_Holder_For_ruleiconconfig = 5 Then IniWrite($MacroINI, $INISection, "icon_ruleslot5", $read)
	If $ID_Holder_For_ruleiconconfig = 6 Then IniWrite($MacroINI, $INISection, "icon_ruleslot6", $read)
	If $ID_Holder_For_ruleiconconfig = 7 Then IniWrite($MacroINI, $INISection, "icon_ruleslot7", $read)
	If $ID_Holder_For_ruleiconconfig = 8 Then IniWrite($MacroINI, $INISection, "icon_ruleslot8", $read)
	If $ID_Holder_For_ruleiconconfig = 9 Then IniWrite($MacroINI, $INISection, "icon_ruleslot9", $read)
	If $ID_Holder_For_ruleiconconfig = 10 Then IniWrite($MacroINI, $INISection, "icon_ruleslot10", $read)
	GUICtrlSetImage($ruleslot_ico_preview, $smallIconsdll, $read)
EndFunc   ;==>_hit_icon

Func _ISN_execute_macroslot_01()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot1) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_01

Func _ISN_execute_macroslot_02()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot2) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_02

Func _ISN_execute_macroslot_03()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot3) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_03

Func _ISN_execute_macroslot_04()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot4) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_04

Func _ISN_execute_macroslot_05()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot5) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_05

Func _ISN_execute_macroslot_06()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot6) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_06

Func _ISN_execute_macroslot_07()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot7) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_07

Func _ISN_execute_macroslot_08()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot8) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_08

Func _ISN_execute_macroslot_09()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot9) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_09

Func _ISN_execute_macroslot_10()
	If $Offenes_Projekt = "" Then Return
	If _run_rule($Section_Trigger_MacroSlot10) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(618)) = 0 Then MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(618), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_ISN_execute_macroslot_10

Func _MakroTesten()
	If $Offenes_Projekt = "" Then Return
	$RuleID = GUICtrlRead($rule_ID)
	If $RuleID = "" Then Return
	GUICtrlSetState($newrule_GUI_TestButton, $GUI_DISABLE)
	GUISetState(@SW_DISABLE, $newrule_GUI)
	$Regel_lauft = 1
	_MacroProcessActions($RuleID, $MacroTestSection, _ISN_Macros_GetMacroINIPath())
	$Regel_lauft = 0
	Sleep(100)
	GUISetState(@SW_ENABLE, $newrule_GUI)
	GUICtrlSetState($newrule_GUI_TestButton, $GUI_ENABLE)
EndFunc   ;==>_MakroTesten

Func _ISN_Macros_GetMacroINIPath()
	Local $MacroINI = $Pfad_zur_Project_ISN
	If GUICtrlRead($macro_type_input) = "global" Then $MacroINI = $GlobalMacrosINIPath
	Return $MacroINI
EndFunc   ;==>_ISN_Macros_GetMacroINIPath
